<?php


class mDBh {

    private $host = "";
    private $user = "";
    private $pass = "";
    private $dbname = "";
    
    private $dbh;
    private $error;
    private $stmt;
    
    public function __construct()
    {
        include_once('config.php');
	
	$this->host = _DB_HOST_;
	$this->user = _DB_USER_;
	$this->pass = _DB_PASS_;
	$this->dbname = _DB_NAME_;
	
	$dsn = 'mysql:host=' . $this->host . ';dbname=' . $this->dbname;

        $options = array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                           /* PDO::ATTR_EMULATE_PREPARES => false */);

        try{
            $this->dbh = new PDO($dsn, $this->user, $this->pass, $options);
        } catch(PDOException $e){
            $this->error = $e->getMessage();
            //die($this->error);
        }       
    }
    
    public function prepare($query){
        //$query = $this->dbh->quote($query);
        $this->stmt = $this->dbh->prepare($query);
    }    

    public function quote($value){
        return $this->dbh->quote($value);
    }    

    public function bindParm($param, $value, $type = null){
        if (is_null($type)) {
            switch (true) {
                case is_int($value):
                    $type = PDO::PARAM_INT;
                    break;
                case is_bool($value):
                    $type = PDO::PARAM_BOOL;
                    break;
                case is_null($value):
                    $type = PDO::PARAM_NULL;
                    break;
                default:
                    $type = PDO::PARAM_STR;
            }
        }
        $this->stmt->bindValue($param, $value, $type);
    }

    public function bindParms($parms){
        if(is_array($parms)){
            foreach($parms as $parm=>$val){
                $this->bindParm($parm, $val);
            }
            //return $dbh;
        }
    }

    public function execute(){
        return $this->stmt->execute();
    }

    public function resultRows(){
        $this->execute();
        return $this->stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    
    public function resultRow(){
        $this->execute();
        return $this->stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    public function rowCount(){
        return $this->stmt->rowCount();
    }
    
    public function lastInsertId(){
        return $this->dbh->lastInsertId();
    }    

    public function beginTransaction(){
        return $this->dbh->beginTransaction();
    }

    public function endTransaction(){
        return $this->dbh->commit();
    }

    public function cancelTransaction(){
        return $this->dbh->rollBack();
    }

    public function debugDumpParams(){
        return $this->stmt->debugDumpParams();
    }

    public function cleanUP(){
        $this->stmt->closeCursor();
    }
}
?>
