<?php //include config
require_once('includes/config.php');

//if not logged in redirect to login page
if(!$user->is_logged_in()){ header('Location: login.php'); }

if(isset($_GET['id'])){
	if($_GET['id']==0){ header('Location: index.php'); }
}

$residentID='';
if(isset($_GET['id'])) $residentID=$_GET['id'];
if($residentID<>''){
	try {

		//find resident's details
		$stmt = $db->prepare('SELECT residentID, first_name, last_name, room_number, balance FROM residents WHERE residentID = :residentID') ;
		$stmt->execute(array(':residentID' => $_GET['id']));
		$row = $stmt->fetch(); 


		$title=$row['first_name']." ".$row['last_name'].": ";
	} catch(PDOException $e) {
		echo $e->getMessage();
	}
}	
?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Petty Cash ADD Transaction</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- Select2 -->
		<link rel="stylesheet" href="plugins/select2/select2.min.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<?php
					if ($_GET['action']=="use") echo "<div class='callout callout-danger'><h3>".$title."USE Money</h3></div>";
					if ($_GET['action']=="add") echo "<div class='callout callout-success'><h3>".$title."ADD Money</h3></div>";
					?>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<!-- /.box-header -->
						<div class="box-body">
							<?php
								//if form has been submitted process it
								if(isset($_POST['submit'])){
								
									//collect form data
									extract($_POST);
								
									//very basic validation
									if($residentID ==''){
										$residentID = $_GET['id'];
										if($residentID ==''){
											$error[] = 'Please select a resident.';
										}
									}
									
									if ($_GET['id']<>1) {
										if($comment ==''){
											$error[] = 'Please enter the comment.';
										}
									}
									
									if ($submit=='For Resident') {
										if($comment ==''){
											$error[] = 'Please enter the comment.';
										}
										if($residentFOR ==''){
											$error[] = 'Please choose a Resident.';
										}
									}
									
									if($amount ==''){
										$error[] = 'Please enter the amount.';
									} else {
										$amount=abs($amount);
										if ($_GET['action']=="use") $amount= -$amount;
									}
								
								
									if(!isset($error)){
								
										try {
											
											if($_POST['submit']=='Add Transaction'){
												//insert transaction
												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':amount' => $amount,
													':comment' => $comment,
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find resident's balance
												$stmt = $db->prepare('SELECT balance,first_name,last_name,room_number FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => $residentID));
												$row = $stmt->fetch(); 

												//update resident's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':balance' => $row['balance'] + $amount
												));
												
												if ($residentID<>0){
													//update Reception Transaction
													$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
													$stmt->execute(array(
														':residentID' => 0,
														':amount' => $amount,
														':comment' => $comment.' for Room# '.$row['room_number'].' - '.$row['first_name'].' '.$row['last_name'] ,
														':date' => $date,
														':who' => $_SESSION['userID']
													));

													//find Reception's balance
													$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
													$stmt->execute(array(':residentID' => 0));
													$row1 = $stmt->fetch(); 

													//update Reception's balance
													$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
													$stmt->execute(array(
														':residentID' => 0,
														':balance' => $row1['balance'] + $amount
													));
												}
											}
												
											if($_POST['submit']=='From Reception'){
												//insert transaction
												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':amount' => $amount,
													':comment' => 'Transfer from Reception',
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find resident's balance
												$stmt = $db->prepare('SELECT balance,first_name,last_name,room_number FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => $residentID));
												$row = $stmt->fetch(); 

												//update resident's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':balance' => $row['balance'] + $amount
												));

												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => 0,
													':amount' => -$amount,
													':comment' => 'Transfer to Bank',
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find Reception's balance
												$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => 0));
												$row1 = $stmt->fetch(); 

												//update Reception's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => 0,
													':balance' => $row1['balance'] - $amount
												));
											}
											
											if($_POST['submit']=='For Resident'){
												//insert transaction
												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':amount' => $amount,
													':comment' => 'Incoming Transfer for Resident: '.$comment,
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find resident's balance
												$stmt = $db->prepare('SELECT balance,first_name,last_name,room_number FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => $residentID));
												$row = $stmt->fetch(); 

												//update resident's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':balance' => $row['balance'] + $amount
												));

												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => $residentFOR,
													':amount' => $amount,
													':comment' => 'Incoming Transfer from bank: '.$comment,
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find residentFOR's balance
												$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => $residentFOR));
												$row1 = $stmt->fetch(); 

												//update residentFOR's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => $residentFOR,
													':balance' => $row1['balance'] + $amount
												));
											}

											if($_POST['submit']=='To Reception'){
												//insert transaction
												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':amount' => $amount,
													':comment' => 'Transfer to Reception',
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find resident's balance
												$stmt = $db->prepare('SELECT balance,first_name,last_name,room_number FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => $residentID));
												$row = $stmt->fetch(); 

												//update resident's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => $residentID,
													':balance' => $row['balance'] + $amount
												));

												$stmt = $db->prepare('INSERT INTO transactions (residentID,amount,comment,date,who) VALUES (:residentID, :amount, :comment, :date, :who)') ;
												$stmt->execute(array(
													':residentID' => 0,
													':amount' => -$amount,
													':comment' => 'Transfer from Bank',
													':date' => $date,
													':who' => $_SESSION['userID']
												));

												//find find Reception's balance
												$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
												$stmt->execute(array(':residentID' => 0));
												$row1 = $stmt->fetch(); 

												//update Reception's balance
												$stmt = $db->prepare('UPDATE residents SET balance = :balance WHERE residentID = :residentID') ;
												$stmt->execute(array(
													':residentID' => 0,
													':balance' => $row1['balance'] - $amount
												));
											}

											//redirect to index page
											header('Location: index.php?action=added');
											exit;
								
										} catch(PDOException $e) {
											echo $e->getMessage();
										}
								
									}
								
								}
								
								//check for any errors
								if(isset($error)){
									echo "<div class='alert alert-danger alert-dismissible'>
											<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
											<h4><i class='icon fa fa-ban'></i> Alert!</h4>";
									foreach($error as $error){
										echo '<p>'.$error.'</p>';
									}
									echo "</div>";
								}
								?>
							<form action='' method='post'>
								<?php 
								$residentID='';
								if(isset($_GET['id'])) $residentID=$_GET['id'];
								if($residentID<>''){
									try {

										//find resident's details
										$stmt = $db->prepare('SELECT residentID, first_name, last_name, room_number, balance FROM residents WHERE residentID = :residentID') ;
										$stmt->execute(array(':residentID' => $_GET['id']));
										$row = $stmt->fetch(); 

									?>
									<div class="form-group">
											<label for="residentID"><?php echo "Add Transaction for ".$row['first_name']." ".$row['last_name']." - Room# ".$row['room_number']." - Balance: $ ".$row['balance'];?></label>
									</div>
									<?php
									} catch(PDOException $e) {
										echo $e->getMessage();
									}
								} else {
									try {

										//find resident's details
										$stmt = $db->query('SELECT residentID, first_name, last_name, room_number FROM residents ORDER BY first_name, last_name') ;

									?>
									<div class="form-group">
											<label for="residentID">Resident</label>
											<select id="residentID" name="residentID" class="form-control select2" style="width: 100%;">
											  <option></option>
											  <?php
											  while($row = $stmt->fetch()){
												  echo "<option value=" . $row['residentID'] . ">".$row['first_name']." ".$row['last_name']." - Room# ".$row['room_number']."</option>";
											  }  
											  ?>
											</select>
									</div>
									<?php
									} catch(PDOException $e) {
										echo $e->getMessage();
									}
								}
								?>
								<div class="form-group">
									<?php
									if ($residentID==1 AND $_GET['action']<>"use") {
										try {

											//find resident's details
											$stmt = $db->query('SELECT residentID, first_name, last_name, room_number FROM residents where room_number<>0 ORDER BY first_name, last_name') ;

										?>
										<div class="form-group">
												<label for="residentFOR">Resident</label>
												<select id="residentFOR" name="residentFOR" class="form-control select2" style="width: 100%;">
												  <option></option>
												  <?php
												  while($row = $stmt->fetch()){
													  echo "<option value=" . $row['residentID'] . ">".$row['first_name']." ".$row['last_name']." - Room# ".$row['room_number']."</option>";
												  }  
												  ?>
												</select>
										</div>
										<?php
										} catch(PDOException $e) {
											echo $e->getMessage();
										}
									}

									if ($residentID<>1 OR ($residentID==1 AND $_GET['action']<>"use")) {

										?>
										<div id="commentGroup" class="form-group">
												<label for="comment">Comment</label>
												<input type="text" class="form-control" id="comment" placeholder="comment" name='comment' value='<?php if(isset($error)){ echo $_POST['comment'];}?>'>
										</div>
										<?php
									}
									
									?>
								</div>
								<div class="form-group">
									<label for="amount">Amount</label>
									<input type="text" class="form-control" id="amount" placeholder="Amount" name='amount' value='<?php if(isset($error)){ echo $_POST['amount'];}?>'>
								</div>
								
								<?php
								if ($residentID<>1) echo '<button type="submit" class="btn btn-primary" name="submit" value="Add Transaction">Add Transaction</button>';
								if ($residentID==1 AND $_GET['action']=='add') {
									echo '<button type="submit" id="SubmitReception" class="btn btn-primary show-reception-button" name="submit" value="From Reception">From Reception</button>';
									echo '<button type="submit" id="SubmitResident" class="btn btn-primary show-resident-button" name="submit" value="For Resident">For Resident</button>';
								}
								if ($residentID==1 AND $_GET['action']=='use') echo '<button type="submit" class="btn btn-primary" name="submit" value="To Reception">To Reception</button>';
								
								?>
							</form>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- Select2 -->
		<script src="plugins/select2/select2.full.min.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
				//Initialize Select2 Elements
				$(".select2").select2({
				  placeholder: "Select a Resident",
				  allowClear: true
				});
			});

			jQuery(document).ready(function() {
				jQuery(".show-reception-button").show();
				jQuery(".show-resident-button").hide();
				<?php if ($residentID==1 AND $_GET['action']=="add") { ?>
					jQuery("#commentGroup").hide();
				<?php } ?>
				$('.show-resident-button').prop('type', 'button');
				$('.show-reception-button').prop('type', 'submit');
			});

			jQuery("#residentFOR").change(function() {
				if(this.value.replace(/\s/g, "") === "") {
				   jQuery(".show-reception-button").show();
				   jQuery(".show-resident-button").hide();
				   jQuery("#commentGroup").hide();
					$('.show-resident-button').prop('type', 'button');
					$('.show-reception-button').prop('type', 'submit');
				} else {
				   jQuery(".show-reception-button").hide();
				   jQuery(".show-resident-button").show();
				   jQuery("#commentGroup").show();
					$('.show-resident-button').prop('type', 'submit');
					$('.show-reception-button').prop('type', 'button');
				}
			});

		
		</script>
	</body>
</html>