<?php
	//include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }
	
?>
<!DOCTYPE html>
<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Petty Cash</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.5 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins -->
  <link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
  <!--[if lt IE 9]>
	  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
	  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
<?php include "header.php";?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        ADD<small>Resident</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Details</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
			<div class="row">
				<div class="col-md-6 col-md-offset-3">
					<?php
						//if form has been submitted process it
						if(isset($_POST['submit'])){
						
							//collect form data
							extract($_POST);
						
							//very basic validation
							if($title ==''){
								$error[] = 'Please enter the title.';
							}
						
							if($first_name ==''){
								$error[] = 'Please enter the First Name.';
							}
						
							if($last_name ==''){
								$error[] = 'Please enter the Last Name.';
							}
						
							if($room_number ==''){
								$error[] = 'Please enter the room number.';
							}
						
							if(!isset($error)){
						
								try {
						
									$postSlug = slug($postTitle);
						
									//insert into database
									$stmt = $db->prepare('INSERT INTO residents (title,first_name,last_name,room_number,comment,who) VALUES (:title, :first_name, :last_name, :room_number, :comment, :who)') ;
									$stmt->execute(array(
										':title' => $title,
										':first_name' => $first_name,
										':last_name' => $last_name,
										':room_number' => $room_number,
										':comment' => $comment,
										':who' => $_SESSION['userID']
									));
									$postID = $db->lastInsertId();
						
									//redirect to index page
									header('Location: index.php?action=added');
									exit;
						
								} catch(PDOException $e) {
								    echo $e->getMessage();
								}
						
							}
						
						}
						
						//check for any errors
						if(isset($error)){
							foreach($error as $error){
								echo '<p class="error">'.$error.'</p>';
							}
						}
						?>
					<form action='' method='post'>
						<div class="form-group">
							<label for="title">Title</label>
							<?php
							echo "<select name='title' class='form-control' id='title'>\n";
							$stmt2 = $db->query('SELECT titleID, name FROM titles ORDER BY name');
							print "<option hidden>Select Title...</option>\n";
							while($row2 = $stmt2->fetch()){
								print "<option value=" . $row2['titleID'] . ">" . $row2['name'] . "</option>\n";
							}
							echo "</select>";
							?>	
						</div>
						<div class="form-group">
							<label for="postDesc">First Name</label>
							<input type="text" class="form-control" id="first_name" placeholder="First Name" name='first_name' value='<?php if(isset($error)){ echo $_POST['first_name'];}?>'>
						</div>
						<div class="form-group">
							<label for="postCont">Last Name</label>
							<input type="text" class="form-control" id="last_name" placeholder="Last Name" name='last_name' value='<?php if(isset($error)){ echo $_POST['last_name'];}?>'>
						</div>
						<div class="form-group">
							<label for="postCont">Room Number</label>
							<input type="text" class="form-control" id="room_number" placeholder="Room Number" name='room_number' value='<?php if(isset($error)){ echo $_POST['room_number'];}?>'>
						</div>
						<div class="form-group">
							<label for="postCont">Comment</label>
							<textarea class="form-control" rows="2" id="comment" placeholder="Comment" name='comment'><?php if(isset($error)){ echo $_POST['comment'];}?></textarea>
						</div>
						<button type="submit" class="btn btn-primary" name='submit' value='Submit'>Submit</button>
					</form>
				</div>
			</div>


			</div>
			</div>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 
  <!-- Main Footer -->
<?php include "footer.php";?>
</div>
<!-- ./wrapper -->

<!-- REQUIRED JS SCRIPTS -->

<!-- jQuery 2.2.0 -->
<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
<!-- Bootstrap 3.3.5 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<script>
$(function () {
    $('#residents').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
});
</script>

</body>
</html>
