<?php
	//include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }
	
	//show message from add / edit page
	if(isset($_GET['deluser'])){ 
	
		//if user id is 1 ignore
		if($_GET['deluser'] !='1'){
	
			$stmt = $db->prepare('DELETE FROM users WHERE userID = :userID') ;
			$stmt->execute(array(':userID' => $_GET['deluser']));
	
			header('Location: users.php?action=Deleted');
			exit;
	
		}
	} 
	
	?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Petty Cash Users</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<script language="JavaScript" type="text/javascript">
			function deluser(id, title)
			{
			 if (confirm("Are you sure you want to delete '" + title + "'"))
			 {
			 	window.location.href = 'users.php?deluser=' + id;
			 }
			}
		</script>
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						Users<small>Listing</small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<?php 
							$infobox="";
							//show message from add / edit page
							if(isset($_GET['action'])){ 

							$infobox="<div class='alert alert-success alert-dismissible'>
							<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
							<h4><i class='icon fa fa-check'></i> ".$_GET['action']."!</h4>
							User ".$_GET['action']." with success. This alert is dismissable.
							</div>";
							} 
							?>
						<div class="box-header">
							<div class="col-md-3"><?php echo $infobox;?></div>
						</div>
						<!-- /.box-header -->
						<div class="box-body">
							<table id="residents" class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Username</th>
										<th>Email</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>
									<?php
										try {
										
											$stmt = $db->query('SELECT userID, username, email FROM users ORDER BY username');
											while($row = $stmt->fetch()){
												
												echo '<tr>';
												echo '<td>'.$row['username'].'</td>';
												echo '<td>'.$row['email'].'</td>';
												?>
									<td>
										<a class="btn btn-primary" href="edit-user.php?id=<?php echo $row['userID'];?>">Edit</a> 
										<?php if($row['userID'] != 1){?>
										<a  class="btn btn-danger"href="javascript:deluser('<?php echo $row['userID'];?>','<?php echo $row['username'];?>')">Delete</a>
										<?php } ?>
									</td>
									<?php 
										echo '</tr>';
										
										}
										
										} catch(PDOException $e) {
										  echo $e->getMessage();
										}
										?>
								</tbody>
								<tfoot>
									<tr>
										<th>Username</th>
										<th>Email</th>
										<th>Action</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
			    $('#residents').DataTable({
			      "paging": false,
			      "lengthChange": false,
			      "searching": false,
			      "ordering": true,
			      "info": true,
			      "autoWidth": false
			    });
			});
		</script>
	</body>
</html>