<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


	//include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }
	$totalbalance=0;
	try {
	
		$stmt = $db->query('SELECT balance FROM residents');
		while($row = $stmt->fetch()){
			$totalbalance=$totalbalance+$row['balance'];
		}
	
	} catch(PDOException $e) {
		echo $e->getMessage();
	}
	
	?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Petty Cash</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						Residents Total Balances
					</h1>
					<ol class="breadcrumb">
						<li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<?php 
							//show message inactive residents
							if(isset($_GET['actif'])){ 
								$actif=0; 
								$h3title="Passive Residents";
							} else {
								$actif=1; 
								$h3title="Active Residents";
							}
							
							//show message from add / edit page
							if(isset($_GET['action'])){ 
								$h3title='Resident '.$_GET['action']; 
							} 
							
							?>
						<div class="box-header">
							<h3 class="box-title"><?php echo $h3title;?></h3>
						</div>
						<!-- /.box-header -->
						<div class="box-body">
							<table id="residents" class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Room</th>
										<th>Name</th>
										<th>Comment</th>
										<th>Amount</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>
									<?php
										try {
										
											$stmt = $db->prepare('SELECT residents.residentID, residents.first_name, residents.last_name, titles.name, residents.room_number, residents.comment, residents.balance FROM residents,titles WHERE residents.title=titles.titleID AND residents.actif= :actif ORDER BY first_name, last_name DESC');
											$stmt->execute(array(':actif' => $actif));
											while($row = $stmt->fetch()){
												
												echo '<tr>';
												echo '<td>'.$row['room_number'].'</td>';
												echo '<td>'.$row['name'].' '.$row['first_name'].' '.$row['last_name'].'</td>';
												echo '<td>'.$row['comment'].'</td>';
												if ($row['balance']<0){
													echo '<td style="color:red;"> $'.$row['balance'].'</td>';
												}else{
													echo '<td> $'.$row['balance'].'</td>';
												}
												?>
									<td>
										<div class="visible-lg">
											<?php if ($row['residentID']<>0) { ?>
											<a class="btn btn-success btn-sm" href="add-transaction.php?id=<?php echo $row['residentID'];?>&action=add">Add Money</a> 
											<a class="btn btn-danger btn-sm" href="add-transaction.php?id=<?php echo $row['residentID'];?>&action=use">Use Money</a> 
											<?php } ?>
											<a class="btn btn-primary btn-sm" href="transactions.php?id=<?php echo $row['residentID'];?>">List Transactions</a> 
											<a class="btn btn-default btn-sm" href="edit-resident.php?id=<?php echo $row['residentID'];?>">Edit Resident</a> 
										</div>
										<div class="visible-md visible-sm visible-xs">
											<?php if ($row['residentID']<>0) { ?>
											<a class="btn btn-success btn-xs" href="add-transaction.php?id=<?php echo $row['residentID'];?>&action=add">Add Money</a> 
											<a class="btn btn-danger btn-xs" href="add-transaction.php?id=<?php echo $row['residentID'];?>&action=use">Use Money</a> 
											<?php } ?>
											<a class="btn btn-primary btn-xs" href="transactions.php?id=<?php echo $row['residentID'];?>">List Transactions</a> 
											<a class="btn btn-default btn-xs" href="edit-resident.php?id=<?php echo $row['residentID'];?>">Edit Resident</a> 
										</div>
									</td>
									<?php 
										echo '</tr>';
										
										}
										
										} catch(PDOException $e) {
										echo $e->getMessage();
										}
										?>
								</tbody>
								<tfoot>
									<tr>
										<th>Room</th>
										<th>Name</th>
										<th>Comment</th>
										<th>Amount</th>
										<th>Action</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
			    $('#residents').DataTable();
			});
		</script>
	</body>
</html>