<?php //include config
require_once('includes/config.php');

//if not logged in redirect to login page
if(!$user->is_logged_in()){ header('Location: login.php'); }

$area = "";

if (isset($_GET['areaID'])) {
	if ($_GET['areaID']<>"") $area = "WHERE m_areas.areaID=".$_GET['areaID'];
}


?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Maintenance Modify Transaction</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Select2 -->
		<link rel="stylesheet" href="plugins/select2/select2.min.css">
		<!-- daterange picker -->
		<link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
		<!-- iCheck for checkboxes and radio inputs -->
		<link rel="stylesheet" href="plugins/iCheck/all.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<style type="text/css" media="print">
			@page 
			{
				size: auto;   /* auto is the initial value */
				margin-top: 10mm;  /* this affects the margin in the printer settings */
				margin-bottom: 10mm;  /* this affects the margin in the printer settings */
				
				@bottom-left {
					content: counter(page) "/" counter(pages);
				}			
			}
			
			.main-footer{
				visibility: hidden;
			}
			
			.col-md-2{
				width:150px
			}
			
			#dateselect{
				visibility: hidden;
				height: 0px;
			}
		</style>
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Modal -->
			<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
			  <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="myModalLabel">Select Area</h4>
				  </div>
				  <div class="modal-body">
					  <div class="box box-primary">
						<div class="box-header with-border">
						  <h3 class="box-title">Area</h3>
						</div>
						<form id="myForm" role="form">
						  <div class="box-body">
										<div class="form-group">
												<select id="areaID" name="areaID" class="form-control Location" style="width: 100%;">
												  <option></option>
												<?php
													$stmt2 = $db->query('SELECT areaID, area_name FROM m_areas ORDER BY area_name');
													while($row2 = $stmt2->fetch()){
														print "<option value=" . $row2['areaID'] . ">" . $row2['area_name'] . "</option>\n";
													}
												?>
												</select>
										</div>
						  </div>
						</form>
					  </div>
				  </div>
					<div class="modal-footer">
						<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
						<button class="btn btn-primary odom-submit">Continue</button>
					</div>    
				</div>
			  </div>
			</div>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<div class="box-body">
						<?php if ($area == "") echo "<h2>All Maintenances per Areas</h2>";?>
						
						<a id="dateselect" class="btn btn-primary" href="#" data-toggle="modal" data-target="#myModal" style="margin-bottom: 20px;">Filter Area</a>
						<?php
						$stmt1 = $db->query("SELECT distinct m_areas.areaID, m_areas.area_name FROM (m_maintenances INNER JOIN m_areas ON (m_maintenances.areaID = m_areas.areaID)) $area ORDER BY m_areas.areaID ASC");
						#$stmt->execute(array(':actif' => $actif));
						while($grouprow = $stmt1->fetch()){
						
						?>			
						<h3><?php echo $grouprow['area_name'];?></h3>
							<table class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Date Lodged</th>
										<th>Type</th>
										<th>comment</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$areaID =$grouprow['areaID'];
									
									$stmt = $db->query("SELECT 
										   m_maintenances.ID,
										   m_areas.area_name,
										   m_categories.category_name,
										   DATE_FORMAT(m_maintenances.date_lodged,'%d %b %Y') as date_lodged,
										   m_maintenances.comment,
										   m_maintenances.activityIDs
										FROM (m_maintenances
											INNER JOIN m_areas
											   ON (m_maintenances.areaID = m_areas.areaID))
										   INNER JOIN m_categories m_categories
											  ON (m_maintenances.categoryID = m_categories.categoryID) 
										WHERE m_areas.areaID=$areaID ORDER BY m_maintenances.date_lodged ASC");
									#$stmt->execute(array(':actif' => $actif));
									while($row = $stmt->fetch()){
										
										echo '<tr>';
										echo '<td class="col-md-2">'.$row['date_lodged'].'</td>';
										echo '<td class="col-md-2">'.$row['category_name'].'</td>';
										echo '<td class="col-md-8">'.$row['comment'].'</td>';
										echo '</tr>';
									}
									?>
								</tbody>
							</table>
						<?php }?>
						</div>
					</div>
				</section>
				<!-- /.content -->
				<section class="content-header">
					<a class="btn btn-default" href="javascript: this.print();">​​​​​​​​​​​​​​​​​print</a>
				</section>
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- Select2 -->
		<script src="plugins/select2/select2.full.min.js"></script>
		<!-- date-range-picker -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.6/moment.min.js"></script>
		<script src="plugins/daterangepicker/daterangepicker.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- iCheck 1.0.1 -->
		<script src="plugins/iCheck/icheck.min.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function(){
				$('body').on('click', '.odom-submit', function (e) {
					$(this.form).submit();
					$('#myModal').modal('hide');
					window.location.replace("maintenance-print-areas.php?areaID=" + document.getElementById('areaID').value);
				});
				$('#myModal').on('shown.bs.modal', function(e) {
					$('#myInput').focus()
				});
			});
			$('#dates').daterangepicker({
				showDropdowns: true,
				locale: {
					"format": "DD MMM YYYY",
					"firstDay": 1
				},
			});
		</script>
	</body>
</html>