<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


	//include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }
	$totalbalance=0;
	try {
	
		$stmt = $db->query('SELECT balance FROM residents');
		while($row = $stmt->fetch()){
			$totalbalance=$totalbalance+$row['balance'];
		}
	
	} catch(PDOException $e) {
		echo $e->getMessage();
	}
	
	?>

			<?php
			//find Reception's balance
			$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
			$stmt->execute(array(':residentID' => 0));
			$row = $stmt->fetch(); 
			$reception_balance=$row['balance'];

			//find Banks's balance
			$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
			$stmt->execute(array(':residentID' => 1));
			$row = $stmt->fetch(); 
			$bank_balance=$row['balance'];

			//on going maintenance
			$stmt = $db->query('SELECT count(*) as maintenance from m_maintenances WHERE fixed=0') ;
			$row = $stmt->fetch(); 
			$maintenance=$row['maintenance'];
			?>
	
	
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Outlook Gardens</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						Dashboard
						<small>Control panel</small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
				  <!-- Small boxes (Stat box) -->
				  <div class="row">
					<div class="col-lg-3 col-xs-6">
					  <!-- small box -->
					  <div class="small-box bg-aqua">
						<div class="inner">
						  <h3><?php echo $bank_balance;?><sup style="font-size: 20px">$</sup></h3>

						  <p>Bank Balance</p>
						</div>
						<div class="icon">
						  <i class="fa fa-university"></i>
						</div>
						<a href="transactions.php?id=1" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
					  </div>
					</div>
					<!-- ./col -->
					<div class="col-lg-3 col-xs-6">
					  <!-- small box -->
					  <div class="small-box bg-green">
						<div class="inner">
						  <h3><?php echo $reception_balance;?><sup style="font-size: 20px">$</sup></h3>

						  <p>Reception Balance</p>
						</div>
						<div class="icon">
						  <i class="ion ion-home"></i>
						</div>
						<a href="transactions.php?id=0" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
					  </div>
					</div>
					<!-- ./col -->
					<div class="col-lg-3 col-xs-6">
					  <!-- small box -->
					  <div class="small-box bg-yellow">
						<div class="inner">
						  <h3><?php echo number_format($bank_balance+$reception_balance,2,'.',"'");?><sup style="font-size: 20px">$</sup></h3>

						  <p>Petty Cash Total</p>
						</div>
						<div class="icon">
						  <i class="glyphicon glyphicon-piggy-bank"></i>
						</div>
						<a href="residents.php" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
					  </div>
					</div>
					<!-- ./col -->
				  </div>
				  <!-- /.row  -->

				  <div class="row">
					<div class="col-lg-3 col-xs-6">
					  <!-- small box -->
					  <div class="small-box bg-red">
						<div class="inner">
						  <h3><?php echo $maintenance;?></h3>

						  <p>On Going Maintenances</p>
						</div>
						<div class="icon">
						  <i class="fa fa-wrench"></i>
						</div>
						<a href="maintenance.php" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
					  </div>
					</div>
					<!-- ./col -->
				  </div>
				  <!-- /.row

				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
			    $('#residents').DataTable();
			});
		</script>
	</body>
</html>