<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


try {

	//find resident's details
	$stmt = $db->prepare('SELECT username FROM users WHERE userID = :userID') ;
	$stmt->execute(array(':userID' => isset($_SESSION['userID'])));
	$row = $stmt->fetch(); 

} catch(PDOException $e) {
	echo $e->getMessage();
}

?>
  <!-- Main Header -->
  <header class="main-header">

    <!-- Logo -->
    <a href="index.php" class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>O</b>G</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><b>Outlook</b> Gardens</span>
    </a>

    <!-- Header Navbar -->
    <nav class="navbar navbar-static-top" role="navigation">

      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>

      <!-- Navbar Right Menu -->
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <!-- User Account Menu -->
          <li class="dropdown user user-menu">

            <!-- Menu Toggle Button -->
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <!-- The user image in the navbar-->
              <img src="dist/img/avatar6.png" class="user-image" alt="User Image">
              <!-- hidden-xs hides the username on small devices so only the image appears. -->
              <span class="hidden-xs"><?php echo $row['username'];?></span>
            </a>
            <ul class="dropdown-menu">
              <!-- The user image in the menu -->
              <li class="user-header">
                <img src="dist/img/avatar6.png" class="img-circle" alt="User Image">
				<p>Administrator <small>All permissions</small></p>
			  </li>
              <!-- Menu Footer-->
              <li class="user-footer">
                 <div class="pull-right">
                  <a href="logout.php" class="btn btn-default btn-flat">Sign out</a>
                </div>
              </li>
            </ul>
          </li>
          <!-- Control Sidebar Toggle Button -->
        </ul>
      </div>
    </nav>
  </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">

      <!-- Sidebar Menu -->
      <ul class="sidebar-menu">
        <li class="header">MENU</li>
        <!-- Optionally, you can add icons to the links -->
        <li class="treeview">
          <a href="#">
            <i class="fa fa-usd"></i> <span>Petty Cash</span>
            <i class="fa fa-angle-left pull-right"></i>
          </a>
          <ul class="treeview-menu">
            <li>
              <a href="#"><i class="fa fa-address-book"></i> Residents <i class="fa fa-angle-left pull-right"></i></a>
              <ul class="treeview-menu">
				<li><a href="residents.php"><i class="fa fa-circle-o"></i> List <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="residents.php?actif=0"><i class="fa fa-circle-o"></i> Show Inactive <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="add-resident.php"><i class="fa fa-circle-o"></i> Add New <i class="fa fa-angle-left pull-right"></i></a></li>
              </ul>
            </li>
			<li>
			  <a href="#"><i class="fa fa-usd"></i> Transactions <i class="fa fa-angle-left pull-right"></i></a>
			  <ul class="treeview-menu">
				<li><a href="transactions.php"><i class="fa fa-circle-o"></i> List <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="add-transaction.php?action=add"><i class="fa fa-circle-o"></i> Add Money <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="add-transaction.php?action=use"><i class="fa fa-circle-o"></i> Use Money <i class="fa fa-angle-left pull-right"></i></a></li>
			  </ul>
			</li>
			<li>
              <a href="#"><i class="fa fa-print"></i> Reports <i class="fa fa-angle-left pull-right"></i></a>
              <ul class="treeview-menu">
				<li><a href="residents-print.php"><i class="fa fa-circle-o"></i> Balances <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="resident-print-transactions.php"><i class="fa fa-circle-o"></i> Transactions <i class="fa fa-angle-left pull-right"></i></a></li>
              </ul>
            </li>
          </ul>
        </li>
        <li class="treeview">
          <a href="#">
            <i class="fa fa-wrench"></i> <span>Maintenance</span>
            <i class="fa fa-angle-left pull-right"></i>
          </a>
          <ul class="treeview-menu">
			<li>
              <a href="#"><i class="fa fa-book"></i> Lists <i class="fa fa-angle-left pull-right"></i></a>
              <ul class="treeview-menu">
				<li><a href="maintenance.php"><i class="fa fa-circle-o"></i> On Going <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="maintenance-history.php"><i class="fa fa-circle-o"></i> All <i class="fa fa-angle-left pull-right"></i></a></li>
              </ul>
            </li>
            <li>
              <a href="add-maintenance.php"><i class="fa fa-plus"></i> Add new <i class="fa fa-angle-left pull-right"></i></a>
			</li>
			<li>
              <a href="#"><i class="fa fa-print"></i> Reports <i class="fa fa-angle-left pull-right"></i></a>
              <ul class="treeview-menu">
				<li><a href="maintenance-print-open.php"><i class="fa fa-circle-o"></i> Open Cases <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="maintenance-print-daterange.php"><i class="fa fa-circle-o"></i> Date Range <i class="fa fa-angle-left pull-right"></i></a></li>
				<li><a href="maintenance-print-areas.php"><i class="fa fa-circle-o"></i> Per Areas <i class="fa fa-angle-left pull-right"></i></a></li>
              </ul>
            </li>
          </ul>
        </li>
        <li class="treeview">
          <a href="#"><i class="fa fa-users"></i> <span>Users</span> <i class="fa fa-angle-left pull-right"></i></a>
          <ul class="treeview-menu">
            <li><a href="users.php">List</a></li>
            <li><a href="add-user.php">Add New</a></li>
          </ul>
        </li>
      <!-- /.sidebar-menu -->
      </ul>

    </section>
    <!-- /.sidebar -->
  </aside>

