<?php //include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }
	?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Petty Cash EDIT Users</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						EDIT<small>User</small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<!-- /.box-header -->
						<div class="box-body">
							<?php
								//if form has been submitted process it
								if(isset($_POST['submit'])){
								
									//collect form data
									extract($_POST);
								
									//very basic validation
									if($username ==''){
										$error[] = 'Please enter the username.';
									}
								
									if( strlen($password) > 0){
								
										if($password ==''){
											$error[] = 'Please enter the password.';
										}
								
										if($passwordConfirm ==''){
											$error[] = 'Please confirm the password.';
										}
								
										if($password != $passwordConfirm){
											$error[] = 'Passwords do not match.';
										}
								
									}
									
								
									if($email ==''){
										$error[] = 'Please enter the email address.';
									}
								
									if(!isset($error)){
								
										try {
								
											if(isset($password)){
								
												$hashedpassword = $user->password_hash($password, PASSWORD_BCRYPT);
								
												//update into database
												$stmt = $db->prepare('UPDATE users SET username = :username, password = :password, email = :email WHERE userID = :userID') ;
												$stmt->execute(array(
													':username' => $username,
													':password' => $hashedpassword,
													':email' => $email,
													':userID' => $userID
												));
								
								
											} else {
								
												//update database
												$stmt = $db->prepare('UPDATE users SET username = :username, email = :email WHERE userID = :userID') ;
												$stmt->execute(array(
													':username' => $username,
													':email' => $email,
													':userID' => $userID
												));
								
											}
											
								
											//redirect to index page
											header('Location: users.php?action=updated');
											exit;
								
										} catch(PDOException $e) {
										    echo $e->getMessage();
										}
								
									}
								
								}
								
								?>
							<?php
								//check for any errors
								if(isset($error)){
									foreach($error as $error){
										echo $error.'<br />';
									}
								}
								
									try {
								
										$stmt = $db->prepare('SELECT userID, username, email FROM users WHERE userID = :userID') ;
										$stmt->execute(array(':userID' => $_GET['id']));
										$row = $stmt->fetch(); 
								
									} catch(PDOException $e) {
									    echo $e->getMessage();
									}
								
								?>
							<form action='' method='post'>
								<div class="form-group">
									<label for="username">Username</label>
									<input type="text" class="form-control" id="username" placeholder="Username" name='username' value='<?php echo $row['username'];?>'>
								</div>
								<div class="form-group">
									<label for="password">Password</label>
									<input type="password" class="form-control" id="password" placeholder="Password" name='password' value=''>
								</div>
								<div class="form-group">
									<label for="passwordConfirm">Confirm Password</label>
									<input type="password" class="form-control" id="passwordConfirm" placeholder="Confirm Password" name='passwordConfirm' value=''>
								</div>
								<div class="form-group">
									<label for="catTitle">Email</label>
									<input type="email" class="form-control" id="email" placeholder="Email" name='email' value='<?php echo $row['email'];?>'>
								</div>
								<button type="submit" class="btn btn-primary" name='submit' value='Update User'>Update User</button>
								<input type='hidden' name='userID' value='<?php echo $row['userID'];?>'>
							</form>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
			    $('#residents').DataTable({
			      "paging": true,
			      "lengthChange": false,
			      "searching": false,
			      "ordering": true,
			      "info": true,
			      "autoWidth": false
			    });
			});
		</script>
	</body>
</html>