<?php
	//include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }
	
?>
<!DOCTYPE html>
<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Petty Cash</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.5 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins -->
  <link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
  <!--[if lt IE 9]>
	  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
	  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
<?php include "header.php";?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        EDIT<small>Resident</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Details</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
			<div class="row">
				<div class="col-md-6 col-md-offset-3">
					<?php
						//if form has been submitted process it
						if(isset($_POST['submit'])){
						
							//collect form data
							extract($_POST);
						
							if ($restricted==1){
							
								try {
									//insert into database
									$stmt = $db->prepare('UPDATE residents SET comment = :comment, date_modified = now(), who = :who WHERE residentID = :residentID') ;
									$stmt->execute(array(
										':comment' => $comment,
										':residentID' => $residentID,
										':who' => $_SESSION['userID']
									));
						
						
									//redirect to index page
									header('Location: index.php?action=updated');
									exit;
						
								} catch(PDOException $e) {
									echo $e->getMessage();
								}
							} else {
								//very basic validation
								if($title ==''){
									$error[] = 'Please enter the title.';
								}
							
								if($first_name ==''){
									$error[] = 'Please enter the First Name.';
								}
							
								if($last_name ==''){
									$error[] = 'Please enter the Last Name.';
								}
							
								if($room_number ==''){
									$error[] = 'Please enter the room number.';
								}
							
								if($actif <> 1){
									$actif = 0;
								}

								if(!isset($error)){
							
									try {
							
										//insert into database
										$stmt = $db->prepare('UPDATE residents SET title = :title, first_name = :first_name, last_name = :last_name, room_number = :room_number, comment = :comment, date_modified = now(), actif = :actif, who = :who WHERE residentID = :residentID') ;
										$stmt->execute(array(
											':title' => $title,
											':first_name' => $first_name,
											':last_name' => $last_name,
											':room_number' => $room_number,
											':comment' => $comment,
											':actif' => $actif,
											':residentID' => $residentID,
											':who' => $_SESSION['userID']
										));
							
							
										//redirect to index page
										header('Location: residents.php?action=updated');
										exit;
							
									} catch(PDOException $e) {
										echo $e->getMessage();
									}
							
								}
							}
						}
						
						?>
					<?php
						//check for any errors
						if(isset($error)){
							foreach($error as $error){
								echo $error.'<br />';
							}
						}
						
							try {
						
								$stmt = $db->prepare('SELECT residentID,first_name,last_name,title,room_number,comment,actif,date_created,date_modified,who,restricted FROM residents WHERE residentID = :residentID') ;
								$stmt->execute(array(':residentID' => $_GET['id']));
								$row = $stmt->fetch(); 
								
								$disabled='';
								if ($row['restricted']==1) $disabled='disabled';
						
							} catch(PDOException $e) {
							    echo $e->getMessage();
							}
						
						?>
					<form action='' method='post'>
						<div class="form-group">
							<label for="title">Title</label>
							<?php
							echo "<select name='title' class='form-control' id='title' $disabled>\n";
							$stmt2 = $db->query('SELECT titleID, name FROM titles ORDER BY name');
							print "<option hidden>Select Title...</option>\n";
							while($row2 = $stmt2->fetch()){
								if ($row2['titleID']==$row['title']){
									print "<option value=" . $row2['titleID'] . " selected>" . $row2['name'] . "</option>\n";
								}else{
									print "<option value=" . $row2['titleID'] . ">" . $row2['name'] . "</option>\n";
								}
							}
							echo "</select>";
							?>	
						</div>
						<div class="form-group">
							<label for="postDesc">First Name</label>
							<input type="text" class="form-control" id="first_name" placeholder="First Name" name='first_name' value='<?php echo $row['first_name'];?>' <?php echo $disabled;?>>
						</div>
						<div class="form-group">
							<label for="postCont">Last Name</label>
							<input type="text" class="form-control" id="last_name" placeholder="Last Name" name='last_name' value='<?php echo $row['last_name'];?>' <?php echo $disabled;?>>
						</div>
						<div class="form-group">
							<label for="postCont">Room Number</label>
							<input type="text" class="form-control" id="room_number" placeholder="Room Number" name='room_number' value='<?php echo $row['room_number'];?>' <?php echo $disabled;?>>
						</div>
						<div class="form-group">
							<label for="postCont">Comment</label>
							<textarea class="form-control" rows="2" id="comment" placeholder="Comment" name='comment'><?php echo $row['comment'];?></textarea>
						</div>
						<fieldset>
							<legend>Status</legend>
							<?php	
								if($row['actif'] == 1){
									$checked = 'checked=checked';
								} else {
									$checked = null;
								}
												
								echo "<div class='checkbox'><label><input type='checkbox' name='actif' value='1' $checked $disabled> Active</label></div>";
							?>
						</fieldset>
						<fieldset>
							<legend>Record Info</legend>
							<div class="row">
								<div class="col-md-4">
									<div class="form-group">
										<label for="postDesc">Created</label>
										<input type="text" class="form-control" id="date_created" name='date_created' value='<?php echo $row['date_created'];?>' disabled>
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label for="postDesc">Modified</label>
										<input type="text" class="form-control" id="date_modified" name='date_modified' value='<?php echo $row['date_modified'];?>' disabled>
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label for="postDesc">Last Action By</label>							
										<?php	
										$stmt2 = $db->query('SELECT username FROM users where userID='.$row['who']);
										while($row2 = $stmt2->fetch()){
											echo '<input type="text" class="form-control" id="username" name="username" value='.$row2['username'].' disabled>';
										}
										?>
									</div>
								</div>
							</div>
						</fieldset>
						<button type="submit" class="btn btn-primary" name='submit' value='Submit'>Update</button>
						<input type='hidden' name='residentID' id='residentID' value='<?php echo $row['residentID'];?>'>
						<input type='hidden' name='restricted' id='restricted' value='<?php echo $row['restricted'];?>'>
					</form>
				</div>
			</div>
			</div>
			</div>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 
  <!-- Main Footer -->
<?php include "footer.php";?>
</div>
<!-- ./wrapper -->

<!-- REQUIRED JS SCRIPTS -->

<!-- jQuery 2.2.0 -->
<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
<!-- Bootstrap 3.3.5 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<script>
$(function () {
    $('#residents').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
});
</script>

</body>
</html>
