<?php //include config
require_once('includes/config.php');

//if not logged in redirect to login page
if(!$user->is_logged_in()){ header('Location: login.php'); }

if(isset($_GET['id'])){
	if($_GET['id']==0){ header('Location: index.php'); }
}

?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Maintenance ADD Transaction</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Select2 -->
		<link rel="stylesheet" href="plugins/select2/select2.min.css">
		<!-- daterange picker -->
		<link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<div class='callout callout-success'><h3>ADD Maintenance</h3></div>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<!-- /.box-header -->
						<div class="box-body">
							<?php
								//if form has been submitted process it
								$activityID = '';
								$fixed = '';
								$checked = '';

								if(isset($_POST['submit'])){
								
									//collect form data
									extract($_POST);
								
									//very basic validation
									if($areaID ==''){
										$error[] = 'Please select maintenenance location.';
									}
									
									if($categoryID ==''){
										$error[] = 'Please select maintenenance type.';
									}

									if($activityID ==''){
										$error[] = 'Please select maintenenance category.';
									} else {
										foreach ($activityID as $a){
											$activityIDs=$a.",".$activityIDs;
										}
										$activityIDs=rtrim($activityIDs,',');
									}

									if($comment ==''){
										$error[] = 'Please enter a comment.';
									}
									
									if($date_lodged ==''){
										$date_lodged = date("Y-m-d");
									} else {
										$date_lodged = date("Y-m-d", strtotime($date_lodged));
									}
								
									if($date_fixed ==''){
										$date_fixed = null;
									} else {
										$date_fixed = date("Y-m-d", strtotime($date_fixed));
									}
									
									if ($fixed =='') $fixed=0;
									if ($checked =='') $checked=0;

									if(!isset($error)){
								
										try {
											
											if($_POST['submit']=='Add Maintenance'){
												//insert transaction
												$stmt = $db->prepare('INSERT INTO m_maintenances (areaID,categoryID,activityIDs,date_lodged,date_fixed,checked,comment,fixed,who) VALUES (:areaID, :categoryID, :activityIDs, :date_lodged, :date_fixed, :comment, :fixed, :checked, :who)') ;
												$stmt->execute(array(
													':areaID' => $areaID,
													':fixed' => $fixed,
													':date_lodged' => $date_lodged,
													':date_fixed' => $date_fixed,
													':comment' => $comment,
													':checked' => $checked,
													':categoryID' => $categoryID,
													':activityIDs' => $activityIDs,
													':who' => $_SESSION['userID']
												));
												
											}
												

											//redirect to index page
											header('Location: index.php?action=added');
											exit;
								
										} catch(PDOException $e) {
											echo $e->getMessage();
										}
								
									}
								
								}
								
								//check for any errors
								if(isset($error)){
									echo "<div class='alert alert-danger alert-dismissible'>
											<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
											<h4><i class='icon fa fa-ban'></i> Alert!</h4>";
									foreach($error as $error){
										echo '<p>'.$error.'</p>';
									}
									echo "</div>";
								}
								?>
							<form action='' method='post'>
								<div class="row">
									<div class="col-md-6">								
										<?php 
										try {

											//find resident's details
											$stmt = $db->query('SELECT areaID, area_name FROM m_areas ORDER BY area_name') ;

										?>
										<div class="form-group">
												<label for="areaID">Location</label>
												<select id="areaID" name="areaID" class="form-control Location" style="width: 100%;">
												  <option></option>
												  <?php
												  while($row = $stmt->fetch()){
													  echo "<option value=" . $row['areaID'] . ">".$row['area_name']."</option>";
												  }  
												  ?>
												</select>
										</div>
										<?php
										} catch(PDOException $e) {
											echo $e->getMessage();
										}
										?>
										<?php 
										try {

											//find resident's details
											$stmt = $db->query('SELECT categoryID, category_name FROM m_categories ORDER BY category_name') ;

										?>
										<div class="form-group">
												<label for="categoryID">Type of maintenance done</label>
												<select id="categoryID" name="categoryID" class="form-control Type" style="width: 100%;">
												  <option></option>
												  <?php
												  while($row = $stmt->fetch()){
													  echo "<option value=" . $row['categoryID'] . ">".$row['category_name']."</option>";
												  }  
												  ?>
												</select>
										</div>
										<?php
										} catch(PDOException $e) {
											echo $e->getMessage();
										}
										?>
											<div class="form-group">
												<label><input type="checkbox" name='checked' id='checked' value='1'> Checked</label>
											</div>											
											<div class="form-group">
												<label><input type="checkbox" name='fixed' id='afixed' value='1'> Fixed</label>
											</div>									</div>
									<div class="col-md-6">								
										<?php 
										try {

											//find resident's details
											$stmt = $db->query('SELECT activityID, activity_name FROM m_activities ORDER BY activity_name') ;

										?>
										<div class="form-group">
												<label for="activityID">Category</label>
												<select id="activityID" name="activityID[]" class="form-control Category" multiple="multiple" data-placeholder="Select a Category" style="width: 100%;">
												  <?php
												  while($row = $stmt->fetch()){
													  echo "<option>".$row['activity_name']."</option>";
												  }  
												  ?>
												</select>
										</div>
										<?php
										} catch(PDOException $e) {
											echo $e->getMessage();
										}
										?>
										<div class="form-group">
											<label for="amount">Date Lodged</label>
											<div class="input-group">
											  <div class="input-group-addon">
												<i class="fa fa-calendar"></i>
											  </div>
											  <input type="text" class="form-control pull-right" id="date_lodged" name="date_lodged" >
											</div>
										</div>
										<div class="form-group">
											<label for="date_fixed">Date Fixed</label>
											<div class="input-group">
											  <div class="input-group-addon">
												<i class="fa fa-calendar"></i>
											  </div>
											  <input type="text" class="form-control pull-right" id="date_fixed" name="date_fixed" >
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-12">
										<div class="form-group">
											<label>Comment</label>
											<textarea id="comment" name="comment" class="form-control" rows="3" placeholder="Enter comment"></textarea>
										</div>
									</div>
								</div>
								<button type="submit" class="btn btn-primary" name="submit" value="Add Maintenance">Add Maintenance</button>
							</form>
						</div>
					</div>
					<div class="box">
						<div class="box-body">
						<h3>Maintenances for this area</h3>
							<table id="maintenances" class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Type</th>
										<th>Comment</th>
										<th>Date Lodged</th>
										<th>Date Fixed</th>
										<th>Category</th>
										<th>Action</th>
									</tr>
								</thead>
								<tfoot>
									<tr>
										<th>Type</th>
										<th>Comment</th>
										<th>Date Lodged</th>
										<th>Date Fixed</th>
										<th>Category</th>
										<th>Action</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- Select2 -->
		<script src="plugins/select2/select2.full.min.js"></script>
		<!-- date-range-picker -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.6/moment.min.js"></script>
		<script src="plugins/daterangepicker/daterangepicker.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
				//Initialize Select2 Elements
				$(".Location").select2({
				  placeholder: "Select a Location",
				  allowClear: true
				});
				$(".Location").on("change", function() {
					ShowRoomMaintenance(this.value);
				});
				$(".Type").select2({
				  placeholder: "Select a Type",
				  allowClear: true
				});
				$(".Category").select2();
				//Date range picker
				$('#date_lodged').daterangepicker({
					singleDatePicker: true,
					showDropdowns: true,
					locale: {
						"format": "DD MMM YYYY",
						"firstDay": 1
					},
				});
				$('#date_fixed').daterangepicker({
					singleDatePicker: true,
					showDropdowns: true,
					locale: {
						"format": "DD MMM YYYY",
						"firstDay": 1
					},
					autoUpdateInput: true,
					autoApply: false
				});
			});
			
			$("#afixed").change(function() {
				var dateStr;
				if (this.checked) {
					var now = new Date();
					var month = new Array();
					month[0] = "Jan";
					month[1] = "Feb";
					month[2] = "Mar";
					month[3] = "Apr";
					month[4] = "May";
					month[5] = "Jun";
					month[6] = "Jul";
					month[7] = "Aug";
					month[8] = "Sep";
					month[9] = "Oct";
					month[10] = "Nov";
					month[11] = "Dec";
					dateStr = now.getDate() + " " + month[now.getMonth()] + " " + now.getFullYear();
				} else {
					dateStr = "";
				}
				$("#date_fixed").val(dateStr);
			});				
				
			function ShowRoomMaintenance(rid) {
				if(rid == "") {
					return;
				}
				
				$('#maintenances').DataTable( {
					"ajax": {
						"url": "includes/roommaintenances.php?rid=" + rid,
						"dataSrc": "roommaintenances"
					},
					order: [[ 2, "desc" ]],
					destroy: true,
					paging: true,
					searching: true
				});
			}
			
			
			
		</script>
	</body>
</html>